/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility.dynamictrees;

import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.minecolonies.api.compatibility.dynamictrees.DynamicTreeProxy;
import com.minecolonies.api.util.Log;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public final class DynamicTreeCompat
extends DynamicTreeProxy {
    private static DynamicTreeCompat instance = new DynamicTreeCompat();
    private static final String DYNAMIC_TREE_DAMAGE = "fallingtree";
    private static final Map<RegistryKey<World>, FakePlayer> fakePlayers = new HashMap<RegistryKey<World>, FakePlayer>();

    @Override
    public boolean isDynamicTreePresent() {
        return true;
    }

    public static boolean isDynTreePresent() {
        return instance.isDynamicTreePresent();
    }

    @Override
    public boolean checkForDynamicTreeBlock(@NotNull Block block) {
        return block instanceof BranchBlock;
    }

    public static boolean isDynamicTreeBlock(Block block) {
        return instance.checkForDynamicTreeBlock(block);
    }

    @Override
    public boolean checkForDynamicLeavesBlock(Block block) {
        return block instanceof DynamicLeavesBlock;
    }

    public static boolean isDynamicLeavesBlock(Block block) {
        return instance.checkForDynamicLeavesBlock(block);
    }

    @Override
    public boolean checkForDynamicTrunkShellBlock(Block block) {
        return block instanceof TrunkShellBlock;
    }

    public static boolean isDynamicTrunkShellBlock(Block block) {
        return instance.checkForDynamicTrunkShellBlock(block);
    }

    @Override
    public NonNullList<ItemStack> getDropsForLeaf(@NotNull IWorld world, @NotNull BlockPos pos, @NotNull BlockState blockState, int fortune, @NotNull Block leaf) {
        if (DynamicTreeCompat.isDynamicLeavesBlock(leaf)) {
            ItemStack stack = ((DynamicLeavesBlock)leaf).getFamily(blockState, (IBlockReader)world, pos).getCommonSpecies().getSeedStack(1);
            NonNullList list = NonNullList.func_191196_a();
            list.add((Object)stack);
            return list;
        }
        return NonNullList.func_191196_a();
    }

    public static NonNullList<ItemStack> getDropsForLeafCompat(IWorld world, BlockPos pos, BlockState blockState, int fortune, Block leaf) {
        return instance.getDropsForLeaf(world, pos, blockState, fortune, leaf);
    }

    @Override
    public boolean checkForDynamicSapling(@NotNull Item item) {
        return item instanceof Seed;
    }

    public static boolean isDynamicTreeSapling(Item item) {
        return instance.checkForDynamicSapling(item);
    }

    public static boolean isDynamicTreeSapling(ItemStack stack) {
        return instance.checkForDynamicSapling(stack.func_77973_b());
    }

    @Override
    public Runnable getTreeBreakActionCompat(@NotNull World world, @NotNull BlockPos blockToBreak, ItemStack toolToUse, BlockPos workerPos) {
        return () -> {
            BlockState curBlockState = world.func_180495_p(blockToBreak);
            Block curBlock = curBlockState.func_177230_c();
            if (world.func_73046_m() == null) {
                Log.getLogger().error("Minecolonies:DynamicTreeCompat unexpected null while trying to get World");
                return;
            }
            RegistryKey dim = world.func_234923_W_();
            FakePlayer fake = fakePlayers.get(dim);
            if (fake == null) {
                fakePlayers.put((RegistryKey<World>)dim, new FakePlayer((ServerWorld)world, new GameProfile(UUID.randomUUID(), "minecolonies_LumberjackFake")));
                fake = fakePlayers.get(dim);
            }
            if (workerPos != null) {
                fake.func_70107_b((double)workerPos.func_177958_n(), (double)workerPos.func_177956_o(), (double)workerPos.func_177952_p());
            }
            if (toolToUse != null) {
                fake.func_184611_a(Hand.MAIN_HAND, toolToUse);
            }
            curBlock.removedByPlayer(curBlockState, world, blockToBreak, (PlayerEntity)fake, true, world.func_204610_c(blockToBreak));
        };
    }

    public static Runnable getTreeBreakAction(World world, BlockPos blockToBreak, ItemStack toolToUse, BlockPos workerPos) {
        return instance.getTreeBreakActionCompat(world, blockToBreak, toolToUse, workerPos);
    }

    @Override
    public boolean plantDynamicSaplingCompat(@NotNull World world, @NotNull BlockPos location, @NotNull ItemStack saplingStack) {
        if (saplingStack.func_77973_b() instanceof Seed) {
            return ((Seed)saplingStack.func_77973_b()).getSpecies().plantSapling((IWorld)world, location, false);
        }
        return false;
    }

    public static boolean plantDynamicSapling(World world, BlockPos location, ItemStack sapling) {
        return instance.plantDynamicSaplingCompat(world, location, sapling);
    }

    @Override
    public String getDynamicTreeDamage() {
        return DYNAMIC_TREE_DAMAGE;
    }

    @Override
    public boolean hasFittingTreeFamilyCompat(@NotNull BlockPos block1, @NotNull BlockPos block2, @NotNull IWorld world) {
        Family fam1 = DynamicTreeCompat.getFamilyForBlock(block1, world);
        Family fam2 = DynamicTreeCompat.getFamilyForBlock(block2, world);
        if (fam1 != null && fam2 != null) {
            return fam1 == fam2;
        }
        return false;
    }

    private static Family getFamilyForBlock(@NotNull BlockPos blockPos, @NotNull IWorld world) {
        Block block = world.func_180495_p(blockPos).func_177230_c();
        if (block instanceof BranchBlock) {
            return ((BranchBlock)block).getFamily();
        }
        if (block instanceof DynamicLeavesBlock) {
            return ((DynamicLeavesBlock)block).getFamily(world.func_180495_p(blockPos), (IBlockReader)world, blockPos);
        }
        return null;
    }

    public static boolean hasFittingTreeFamily(@NotNull BlockPos block1, @NotNull BlockPos block2, @NotNull IWorld world) {
        return instance.hasFittingTreeFamilyCompat(block1, block2, world);
    }
}

